#include <stdlib.h>
#include <unistd.h>
#include <stdio.h>
#include <string.h>

#include <gm.h>
#include <libldiag.h>
#include "gmstuff.h"

void send_callback (struct gm_port *port, void *buf, gm_status_t rc);

int Sends;

struct gm_port *myport;
unsigned char route[32];
int rlen;

void
wait_ms(int wait)
{
  gm_u64_t start;

  start = gm_ticks(myport);
  while (gm_ticks(myport) < (start + (wait*1024*2)))
    ;
}

int
main (int argc, char **argv)
{
  gm_status_t rc;
  unsigned char *tbuf;
  unsigned char *ibuf;
  int i;
  int j;
  int c;
  int boardno;
  int portno;
  union gm_recv_event *event;
  unsigned int val;
  int claimed_rlen;
  int num_sends;
  int interleave;
  int waittime;
  int msglen;

  extern char *optarg;
  extern int optind;

  interleave = 0;
  num_sends = 10;
  boardno = 0;
  rlen = -1;
  claimed_rlen = -1;
  waittime = 0;
  msglen = 0;

  while ((c = getopt (argc, argv, "iw:n:B:r:l:L:")) != EOF)
    switch (c)
      {
      case 'w':
        waittime = atoi(optarg);
	break;
      case 'i':
        interleave = 1;
        break;
      case 'n':
	num_sends = atoi(optarg);
	break;
      case 'r':
        rlen = 0;
	--optind;
        while (optind < argc && argv[optind][0] != '-') {
	  sscanf(argv[optind], "%x", &val);
	  route[rlen++] = val;
	  ++optind;
	}
	break;
      case 'l':
        claimed_rlen = atoi(optarg);
	break;
      case 'L':
        msglen = atoi(optarg);	/* how much un addition to route? */
        break;
      case 'B':
	boardno = atoi (optarg);
	break;
      default:
	fprintf (stderr, "Error in arguments\n");
	exit (1);
      }

  if (rlen == -1) {
    route[0] = 0x80;
    rlen = 0;
  }
  if (claimed_rlen == -1) {
    claimed_rlen = rlen;
  }

  /* Initialize GM */
  rc = gm_init ();
  if (rc != GM_SUCCESS)
    {
      gm_perror ("gm_init()", rc);
      exit (1);
    }

  rc = _gm_mapper_open (&myport, boardno, GM_API_VERSION_1_6);
  if (rc != GM_SUCCESS)
    {
      gm_perror ("gm_open()", rc);
      exit (1);
    }
  printf ("Successfully opened board %d, port %d\n", boardno, portno);

  /* create a send buffer */
  tbuf = gm_dma_malloc (myport, rlen+msglen);
  ibuf = gm_dma_malloc (myport, 256);
  if (tbuf == NULL || ibuf == NULL)
    {
      fprintf (stderr, "gm_dma_malloc failed!\n");
      exit (1);
    }

  /* build the send buffer */
  bcopy(route, tbuf, rlen);
  bzero(tbuf+rlen, msglen);

  for (j = 0; j < msglen + rlen; ++j)
    printf ("%02x ", (unsigned int) tbuf[j]);
  puts ("");
  printf("claimed_rlen = %d, rlen = %d\n", claimed_rlen, rlen);

  /* build buffer for interleaved sends which we may or may not use */
  ibuf[0] = 0x80;

  /* Now, fire off the send a few times*/
  Sends = 0;
  for (i = 0; i < num_sends; ++i)
    {
      _gm_raw_send_with_callback (myport, tbuf, msglen + rlen,
				claimed_rlen, send_callback, tbuf);
      ++Sends;

      if (interleave) {
	_gm_raw_send_with_callback (myport, ibuf, 2,
				1, send_callback, ibuf);
        ++Sends;
      }

      if (waittime) wait_ms(waittime);
    }

  /* Loop waiting for something to happen */
  while (Sends > 0)
    {
      event = gm_blocking_receive_no_spin (myport);

printf("event type: %d, rx event type: %d\n", GM_RECV_EVENT_TYPE (event), GM_RAW_RECV_EVENT);
      gm_unknown (myport, event);
    }

  printf ("all done!\n");
  exit (0);
}

void
send_callback (struct gm_port *port, void *buf, gm_status_t rc)
{
  if (rc != GM_SUCCESS)
    {
      gm_perror ("send error", rc);
      fprintf (stderr, "buffer = %p\n", buf);
      exit (1);
    }
  else
    {
      --Sends;
    }
}
